# Monetization resources
The following documents develop your understanding of how to effectively use Unity's monetization platform. Use all the tools available to maximize your revenue.

* The [**dashboard**](MonetizationResourcesDashboardGuide.md) guide is a detailed walkthrough of the [Unity developer dashboard](https://operate.dashboard.unity3d.com/), where you configure monetization [Placements](MonetizationPlacements.md) and settings.
* The [**mediation**](MonetizationResourcesMediation.md) article provides reference material for developers who implement Unity Ads through a mediation stack.
* The [**statistics and reporting**](MonetizationResourcesStatistics.md) guide describes how to harness performance data from your monetization campaigns through the developer dashboard interface or Unity Ads Statistics API.
* The [**revenue and payment**](MonetizationResourcesRevenueAndPayment.md) guide provides an overview of how to accrue and collect revenue from Unity Ads.
* The [**S2S redeem callbacks**](MonetizationResourcesRedeemCallbacks.md) guide explains how to use server-to-server callbacks to reward users for engaging with Monetization content.
* The [**rewarded ads best practices**](MonetizationResourcesBestPracticesAds.md) guide provides tips for implementing ad content that monetizes effectively.
* The [**Promo best practices**](MonetizationResourcesBestPracticesPromo.md) guide provides tips for implementing [IAP Promo](https://docs.unity3d.com/Manual/IAPPromo.html) content that monetizes effectively.
* The [**iOS API**](MonetizationResourcesApiIos.md) script reference details Objective-C API classes for the Unity Ads iOS SDK.
* The [**Android API**](MonetizationResourcesApiAndroid.md) script reference details Java API classes for the Unity Ads Android SDK. 
The [**FAQs**](MonetizationResourcesFaq.md) article is a collection of frequently asked questions for all things monetization.
